//=============================================================================
// SpashHUDMutator.
// Copyright PJMODOS (pjmodos@atlas.cz)
//=============================================================================
class SplashHUDMutator expands Mutator;

var PlayerPawn Player;

var bool bDrawSplash;

var string LogoTexture;
var int    LogoDrawTime;
var string CaptionLineOne;
var string CaptionLineTwo;
var string CaptionLineThree;
var string CaptionLineFour;
var string IntroSound;

var enum EDrawState
	{
	DRAW_BLANK,
	DRAW_FADE_IN,
	DRAW_DISPLAY,
	DRAW_FADE_OUT,
	DRAW_DONE

	} DrawState;

var float DrawTime;
var float DrawTick;
var bool LogoTranslucent;

var texture SplashLogo;
var sound SplashSound;

simulated function PostRender(canvas Canvas)
{

	Super.PostRender(Canvas);

	if (Player != None)
	if (Player.PlayerReplicationInfo != None)
	if (DrawState != DRAW_DONE)
		{
		if (!bDrawSplash)
			{
			Log("Loading texture "$LogoTexture);
			SplashLogo = texture(DynamicLoadObject(LogoTexture, class'Texture'));
			Log("Loading sound "$IntroSound);
			SplashSound = Sound(DynamicLoadObject(IntroSound, class'Sound'));
			if (SplashLogo != None)
				{
				bDrawSplash = True;
				DrawState = EDrawState.DRAW_BLANK;
				DrawTick = 0.0625;
				SetTimer(DrawTick, True);
				if (SplashSound == None)
					Log("SplashLogo: Can't load sound "$IntroSound);
				}
			else
				{
				DrawState = DRAW_DONE;
				Log("SplashLogo: Can't load texture "$LogoTexture);
				if (SplashSound == None)
					Log("SplashLogo: Can't load sound "$IntroSound);
				}

			}
		else if (DrawState != DRAW_DONE)
			DrawSplash(Canvas);
		}
	if (NextHUDMutator != None) NextHUDMutator.PostRender(Canvas);

}


simulated function DrawSplash(canvas Canvas)
{
	local font PreviousFont;
	local bool PreviousCenter;
	local color PreviousColor;
	local byte PreviousStyle;
    local float W, H;
	if (DrawState != EDrawState.DRAW_BLANK)
		{
		PreviousCenter = Canvas.bCenter;
		PreviousColor = Canvas.DrawColor;
		PreviousFont = Canvas.Font;
		PreviousStyle = Canvas.Style;
		Canvas.Reset();
		Canvas.SetPos(Canvas.ClipX/2 - SplashLogo.Usize/2, Canvas.ClipY/2 + 25);

		Switch (DrawState)
			{
			case EDrawState.DRAW_FADE_IN :
				Canvas.Style = ERenderStyle.STY_Translucent;
				Canvas.DrawColor.R = 225 * DrawTime;
				Canvas.DrawColor.G = 225 * DrawTime;
				Canvas.DrawColor.B = 225 * DrawTime;
				break;

			case EDrawState.DRAW_DISPLAY :
				if(LogoTranslucent)
					Canvas.Style = ERenderStyle.STY_Translucent;
				else
					Canvas.Style = ERenderStyle.STY_Normal;
				Canvas.DrawColor.R = 225;
				Canvas.DrawColor.G = 225;
				Canvas.DrawColor.B = 225;
				break;

			case EDrawState.DRAW_FADE_OUT :
				Canvas.Style = ERenderStyle.STY_Translucent;
				Canvas.DrawColor.R = 225 - (225 * DrawTime);
				Canvas.DrawColor.G = 225 - (225 * DrawTime);
				Canvas.DrawColor.B = 225 - (225 * DrawTime);
				break;
			}

		Canvas.DrawIcon(SplashLogo, 1.0);

		Canvas.Reset();
		Canvas.bCenter = False;

		Switch (DrawState)
			{
			case EDrawState.DRAW_FADE_IN :
			        Canvas.Style = ERenderStyle.STY_Translucent;
				Canvas.DrawColor.R = 225 * DrawTime;
				Canvas.DrawColor.G = 225 * DrawTime;
				Canvas.DrawColor.B = 225 * DrawTime;
				break;

			case EDrawState.DRAW_DISPLAY :
				Canvas.Style = ERenderStyle.STY_Normal;
				Canvas.DrawColor.R = 225;
				Canvas.DrawColor.G = 225;
				Canvas.DrawColor.B = 225;
				break;

			case EDrawState.DRAW_FADE_OUT :
				Canvas.Style = ERenderStyle.STY_Translucent;
				Canvas.DrawColor.R = 225 - (225 * DrawTime);
				Canvas.DrawColor.G = 225 - (225 * DrawTime);
				Canvas.DrawColor.B = 225 - (225 * DrawTime);
				break;
			}

		Canvas.Font = Canvas.SmallFont;
		Canvas.TextSize(CaptionLineOne,W,H);
        Canvas.SetPos(Canvas.ClipX/2 - W/2, Canvas.ClipY/2 + 25+SplashLogo.VSize+10);
		Canvas.DrawText(CaptionLineOne);
		Canvas.TextSize(CaptionLineTwo,W,H);
		Canvas.SetPos(Canvas.ClipX/2 - W/2, Canvas.ClipY/2 + 25+SplashLogo.VSize+20);
		Canvas.DrawText(CaptionLineTwo);
		Canvas.TextSize(CaptionLineThree,W,H);
		Canvas.SetPos(Canvas.ClipX/2 - W/2, Canvas.ClipY/2 + 25+SplashLogo.VSize+30);
		Canvas.DrawText(CaptionLineThree);
		Canvas.TextSize(CaptionLineFour,W,H);
		Canvas.SetPos(Canvas.ClipX/2 - W/2, Canvas.ClipY/2 + 25+SplashLogo.VSize+40);
		Canvas.DrawText(CaptionLineFour);
		Canvas.SetPos(10, 10+SplashLogo.VSize+50);

		Canvas.bCenter = PreviousCenter;
		Canvas.DrawColor = PreviousColor;
		Canvas.Font = PreviousFont;
		Canvas.Style = PreviousStyle;
		}

}


simulated function Timer()
{
	DrawTime = DrawTime + DrawTick;

	Switch (DrawState)
		{
		case EDrawState.DRAW_BLANK :
			if (DrawTime >= 1.0)
				{
				DrawState = EDrawState.DRAW_FADE_IN;
				DrawTime = 0.0;
				}
			break;

		case EDrawState.DRAW_FADE_IN :
			if (DrawTime >= 1.0)
				{
				DrawState = EDrawState.DRAW_DISPLAY;
				DrawTime = 0.0;
				Player.ClientReliablePlaySound(SplashSound);
				}
			break;

		case EDrawState.DRAW_DISPLAY :
			if (DrawTime >= LogoDrawTime)
				{
				DrawState = EDrawState.DRAW_FADE_OUT;
				DrawTime = 0.0;
				}
			break;

		case EDrawState.DRAW_FADE_OUT :
			if (DrawTime >= 1.0)
				{
				DrawState = EDrawState.DRAW_DONE;
				DrawTime = 0.0;
				}
			break;

		case EDrawState.DRAW_DONE :
			SetTimer(0.0, False);
			SplashLogo = None;
			break;
		}

	Super.Timer();
}

